/* -*- mode: C++; tab-width: 4 -*- */
/* ===================================================================== *\
	Copyright (c) 2000-2001 Palm, Inc. or its subsidiaries.
	All rights reserved.

	This file is part of the Palm OS Emulator.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
\* ===================================================================== */

#ifndef EmRegsUSBS1D13A03_h
#define EmRegsUSBS1D13A03_h

#include "EmHAL.h"				// EmHALHandler
#include "EmPalmStructs.h"
#include "EmRegs.h"
#include "EmStructs.h"			// RGBList

class SessionFile;
class EmScreenUpdateInfo;

class EmRegsUSBS1D13A03 : public EmRegs
{
	public:
								EmRegsUSBS1D13A03		(emuptr);
		virtual					~EmRegsUSBS1D13A03		(void);

		virtual void			Initialize			(void);
		virtual void			Reset				(Bool hardwareReset);
		virtual void			Save				(SessionFile&);
		virtual void			Load				(SessionFile&);
		virtual void			Dispose				(void);

		virtual void			SetSubBankHandlers	(void);
		virtual uint8*			GetRealAddress		(emuptr address);
		virtual emuptr			GetAddressStart		(void);
		virtual uint32			GetAddressRange		(void);

	private:
		emuptr							fBaseAddr;
		EmProxyS1D13A03UsbHwrType		fRegs;
};

#endif	/* EmRegsUSBS1D13A03_h */